	 public _one_bit,_one_get,_onecolor
	 public _two_bit,_two_get,_twocolor
	 public _four_bit,_four_get,_fourcolor
	 public _peek,_pokeb,_pokew
	 public	_filler,_vidmode


IGROUP	GROUP	_TEXT
DGROUP	GROUP	_DATA

_DATA	SEGMENT	PUBLIC BYTE 'DATA'
	extrn	_regen:word
	extrn	_get_shift:word
	extrn	_row_start:word
	extrn	_one_mask:byte
	extrn	_two_mask:byte
	extrn	_four_mask:byte
	extrn	_color:byte
_DATA	ends

_TEXT	SEGMENT	PUBLIC BYTE 'CODE'
	ASSUME	CS:IGROUP,DS:DGROUP
;
;        one_bit(column, row)
;        unsigned column, row;
;
_one_bit proc near
	 push bp
	 mov  bp,sp
	 push es
	 push di
	 push si
	 mov es,word ptr _regen  ;regen buffer address
	 mov ax,[bp+4]	   ;ax & di=col
	 mov di,ax
	 and di,7	   ;di=pixel number (0-7)
	 mov si,[bp+6]	   ;si=row
	 add si,si	   ;si = row as a word index
	 mov si,word ptr _row_start[si] ;si=row start addr
	 shr ax,1	       ;col/8
	 shr ax,1
	 shr ax,1
	 add si,ax	       ;si=byte offset of byte of interest
	 mov ah,es:[si]        ;get screen
	 mov al,byte ptr _one_mask[di]  ;get pixel mask
	 and ah,al	       ;put a hole in the screen data
	 not al 	       ;mask is now an extract mask
	 and al,byte ptr _color    ;isolate color from the	color table
	 or  al,ah	       ;put them together
	 mov es:[si],al        ;and onto the screen
	 pop si
	 pop di
	 pop es
	 pop bp
	 ret
_one_bit endp
;
;        two_bit(column, row)
;        unsigned column, row;
;
_two_bit proc near
	 push bp
	 mov  bp,sp
	 push es
	 push di
	 push si
	 mov es,word ptr _regen  ;regen buffer address
	 mov ax,[bp+4]	   ;ax & di=col
	 mov di,ax
	 and di,3	   ;di=pixel number (0-3)
	 mov si,[bp+6]	   ;si=row
	 add si,si	   ;si = row as a word index
	 mov si,word ptr _row_start[si] ;si=row start addr
	 shr ax,1	       ;col/4
	 shr ax,1
	 add si,ax	       ;si=byte offset of byte of interest
	 mov ah,es:[si]        ;get screen
	 mov al,byte ptr _two_mask[di]  ;get pixel mask
	 and ah,al	       ;put a hole in the screen data
	 not al 	       ;mask is now an extract mask
	 and al,byte ptr _color    ;current color
	 or  al,ah	       ;put them together
	 mov es:[si],al        ;and onto the screen
	 pop si
	 pop di
	 pop es
	 pop bp
	 ret
_two_bit endp
;
;four_bit(column, row)
;unsigned column, row;
;
_four_bit proc near
	 push bp
	 mov  bp,sp
	 push es
	 push di
	 push si
	 mov es,word ptr _regen  ;regen buffer address
	 mov ax,[bp+4]	   ;ax & di=col
	 mov di,ax
	 and di,1	   ;di=pixel number (0-1)
	 mov si,[bp+6]	   ;si=row
	 add si,si	   ;si = row as a word index
	 mov si,word ptr _row_start[si] ;si=row start addr
	 shr ax,1	       ;col/2
	 add si,ax	       ;si=byte offset of byte of interest
	 mov ah,es:[si]        ;get screen
	 mov al,byte ptr _four_mask[di]  ;get pixel mask
	 and ah,al	       ;put a hole in the screen data
	 not al 	       ;mask is now an extract mask
	 and al,byte ptr _color    ;isolate color from the	color table
	 or  al,ah	       ;put them together
	 mov es:[si],al        ;and onto the screen
	 pop si
	 pop di
	 pop es
	 pop bp
	 ret
_four_bit endp
;
;int one_get(column, row)
;unsigned column, row;
;
_one_get proc near
	 push bp
	 mov  bp,sp
	 push es
	 push di
	 push si
	 mov es,word ptr _regen  ;regen buffer address
	 mov ax,[bp+4]	     ;ax & di=col
	 mov di,ax
	 and di,7	     ;di=pixel number (0-7)
	 mov bx,word ptr _get_shift
	 mov cl,byte ptr [di+bx] ;pixel alignment shift count;
	 mov si,[bp+6]	     ;si=row
	 add si,si	     ;si = row as a word index
	 mov si,word ptr _row_start[si] ;si=row start addr
	 shr ax,1	       ;col/8
	 shr ax,1
	 shr ax,1
	 add si,ax	       ;si=byte offset of byte of interest
	 mov al,es:[si]        ;get screen
	 shr al,cl	       ;align pixel
	 and ax,1	       ;mask garbage
	 pop si
	 pop di
	 pop es
	 pop bp
	 ret
_one_get endp
;
;int two_get(column, row)
;unsigned column, row;
;
_two_get proc near
	 push bp
	 mov  bp,sp
	 push es
	 push di
	 push si
	 mov es,word ptr _regen  ;regen buffer address
	 mov ax,[bp+4]	     ;ax & di=col
	 mov di,ax
	 and di,3	     ;di=pixel number (0-3)
	 mov bx,word ptr _get_shift
	 mov cl,byte ptr [di+bx] ;pixel shift count
	 mov si,[bp+6]	     ;si=row
	 add si,si	     ;si = row as a word index
	 mov si,word ptr _row_start[si] ;si=row start addr
	 shr ax,1	       ;col/4
	 shr ax,1
	 add si,ax	       ;si=byte offset of byte of interest
	 mov al,es:[si]        ;get screen
	 shr al,cl	       ;align pixel
	 and ax,3	       ;mask garbage
	 pop si
	 pop di
	 pop es
	 pop bp
	 ret
_two_get endp
;
;int four_get(column, row)
;unsigned column, row;
;
_four_get proc near
	 push bp
	 mov  bp,sp
	 push es
	 push di
	 push si
	 mov es,word ptr _regen  ;regen buffer address
	 mov ax,[bp+4]	     ;ax & di=col
	 mov di,ax
	 and di,1	     ;di=pixel number (0-1)
	 mov bx,word ptr _get_shift;
	 mov cl,[di+bx]      ;pixel shift count
	 mov si,[bp+6]	     ;si=row
	 add si,si	     ;si = row as a word index
	 mov si,word ptr _row_start[si] ;si=row start addr
	 shr ax,1	       ;col/2
	 add si,ax	       ;si=byte offset of byte of interest
	 mov al,es:[si]        ;get screen
	 shr al,cl	       ;align pixel
	 and ax,0FH	       ;mask garbage
	 pop si
	 pop di
	 pop es
	 pop bp
	 ret
_four_get endp
;
;int onecolor(column, row, color)
;unsigned column, row, color;
;
_onecolor proc near
	 push bp
	 mov  bp,sp
	 push es
	 push di
	 push si
	 mov es,word ptr _regen  ;regen buffer address
	 mov ax,[bp+4]	     ;ax & di=col
	 mov si,[bp+6]	     ;si=row
	 add si,si	     ;si = row as a word index
	 mov si,word ptr _row_start[si] ;si=row start addr
	 shr ax,1	       ;col/8
	 shr ax,1
	 shr ax,1
	 add si,ax	       ;si=byte offset of byte of interest
	 mov al,es:[si]        ;get screen
	 test byte ptr [bp+8],1	;zero or one being tested for?
	 jz  ckzero
	 inc al
ckzero:	 or  al,al
	 jnz ret1
	 xor ax,ax
	 jmp retx
ret1:	 mov ax,1
retx:	 pop si
	 pop di
	 pop es
	 pop bp
	 ret
_onecolor endp
;
;int twocolor(column, row, color)
;unsigned column, row, color;
;
_twocolor proc near
	 push bp
	 mov  bp,sp
	 push es
	 push di
	 push si
	 mov es,word ptr _regen  ;regen buffer address
	 mov ax,[bp+4]	     ;ax & di=col
	 mov di,ax
	 and di,3	     ;di=pixel number (0-3)
	 mov si,[bp+6]	     ;si=row
	 add si,si	     ;si = row as a word index
	 mov si,word ptr _row_start[si] ;si=row start addr
	 shr ax,1	       ;col/4
	 shr ax,1
	 add si,ax	       ;si=byte offset of byte of interest
	 mov al,es:[si]        ;get screen
	 mov ah,[bp+8]
	 mov ch,al
	 and ax,0303h
	 cmp ah,al
	 jz  colok
	 shr ch,1
	 shr ch,1
	 mov al,ch
	 and al,03h
	 cmp ah,al
	 jz  colok
	 shr ch,1
	 shr ch,1
	 mov al,ch
	 and al,03h
	 cmp ah,al
	 jz  colok
	 shr ch,1
	 shr ch,1
	 cmp ah,ch
	 jz  colok
	 xor ax,ax
	 jmp colx
colok:	 mov ax,1
colx:	 pop si
	 pop di
	 pop es
	 pop bp
	 ret
_twocolor endp
;
;int fourcolor(column, row, color)
;unsigned column, row, color;
;
_fourcolor proc near
	 push bp
	 mov  bp,sp
	 push es
	 push di
	 push si
	 mov es,word ptr _regen  ;regen buffer address
	 mov ax,[bp+4]	     ;ax & di=col
	 mov si,[bp+6]	     ;si=row
	 add si,si	     ;si = row as a word index
	 mov si,word ptr _row_start[si] ;si=row start addr
	 shr ax,1	       ;col/2
	 add si,ax	       ;si=byte offset of byte of interest
	 mov al,es:[si]        ;get screen
	 mov ah,al
	 mov cl,4
	 shr ah,cl
	 and al,0Fh
	 cmp ah,[bp+8]
	 jz  gotcol
	 cmp al,[bp+8]
	 jz  gotcol
	 xor ax,ax
	 jmp gotx
gotcol:	 mov ax,1
gotx:	 pop si
	 pop di
	 pop es
	 pop bp
	 ret
_fourcolor endp
;
;   filler(start, segment, end, pattern)
;       unsigned start, segment, end, pattern;
;
_filler proc near
	push bp
	mov  bp,sp
	push es
	push di
	push si
	les	di,dword ptr [4+bp] ;get start of block into ES:DI
	mov	ax,[10+bp]	;get PATTERN into AX
	cld			;strings go forward
	mov	cx,[8+bp]	;get END addr into CX
	sub	cx,di		;convert end to byte count
	shr	cx,1
	jz	fill_done
	rep stosw
fill_done:
	jnc	fill_exit
	mov	es:[di+1],ah
fill_exit:
	stosb
	pop si
	pop di
	pop es
	pop bp
	ret
_filler endp
;
;   Called as vidmode(mode)
;      sets the BIOS to the video mode specified (0 <= mode <= 18)
;
_vidmode proc	near
	push	bp
	mov	bp,sp
	push	es
	push	ds
	mov	al,4[bp]
	mov	ah,0
	int	10h
	pop	ds
	pop	es
	pop	bp
	ret
_vidmode endp

_peek	proc	near
	push	bp
	mov	bp,sp
	push	es
	les	bx,4[bp]
	mov	ax,es:[bx]
	pop	es
	pop	bp
	ret
_peek	endp

_pokeb	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	bx,4[bp]
	mov	al,byte ptr 8[bp]
	mov	byte ptr ds:[bx],al
	pop	ds
	pop	bp
	ret
_pokeb	endp

_pokew	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	bx,4[bp]
	mov	ax,word ptr 8[bp]
	mov	word ptr ds:[bx],ax
	pop	ds
	pop	bp
	ret
_pokew	endp

_TEXT	 ends
	 end
